/*
 * Decompiled with CFR 0.152.
 */
package lab6c;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.Timer;

public class lab6c {
    public static void main(String[] args) {
        final JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setBounds(0, 0, screen.width / 3, screen.height / 3);
        frame.setResizable(false);
        frame.getContentPane().setBackground(Color.BLACK);
        frame.add(new JComponent(){

            @Override
            public void paintComponent(Graphics g) {
                Graphics2D g2 = (Graphics2D)g;
                g2.setColor(Color.WHITE);
                int hours = LocalTime.now().getHour();
                int minutes = LocalTime.now().getMinute();
                int seconds = LocalTime.now().getSecond();
                int nano = LocalTime.now().getNano();
                DateTimeFormatter format = DateTimeFormatter.ofPattern("hh:mm:ss a");
                frame.setTitle(LocalTime.now().format(format));
                this.drawDialRing(g2);
                this.drawDate(g2);
                g2.rotate(Math.toRadians((double)(hours * 30) + (double)minutes * 30.0 / 60.0 + (double)seconds * 30.0 / 3600.0), frame.getWidth() / 2, frame.getHeight() / 2);
                this.drawHourNeedle(g2);
                g2.rotate(-Math.toRadians((double)(hours * 30) + (double)minutes * 30.0 / 60.0 + (double)seconds * 30.0 / 3600.0), frame.getWidth() / 2, frame.getHeight() / 2);
                g2.rotate(Math.toRadians((double)minutes * 6.0 + (double)seconds * 6.0 / 60.0), frame.getWidth() / 2, frame.getHeight() / 2);
                this.drawMinuteNeedle(g2);
                g2.rotate(-Math.toRadians((double)minutes * 6.0 + (double)seconds * 6.0 / 60.0), frame.getWidth() / 2, frame.getHeight() / 2);
                g2.rotate(Math.toRadians((double)seconds * 6.0 + (double)nano * 6.0 / 1.0E9), frame.getWidth() / 2, frame.getHeight() / 2);
                this.drawSecondNeedle(g2);
                g2.rotate(-Math.toRadians((double)seconds * 6.0 + (double)nano * 6.0 / 1.0E9), frame.getWidth() / 2, frame.getHeight() / 2);
            }

            private void drawDialRing(Graphics2D g2D) {
                int i;
                g2D.setFont(new Font("Brush Script MT", 1, 14));
                String monogram = "ARRT";
                g2D.drawString(monogram, frame.getWidth() / 2 - monogram.length() * 5, frame.getHeight() / 2 - 40);
                g2D.setColor(Color.GRAY);
                for (i = 1; i < 31; ++i) {
                    g2D.rotate(Math.toRadians((double)i * 6.0), frame.getWidth() / 2, frame.getHeight() / 2);
                    g2D.fillRoundRect(frame.getWidth() / 2 - 2, frame.getHeight() / 2 - 7 * frame.getHeight() / 18 - 2, 4, 10, 10, 5);
                    g2D.fillRoundRect(frame.getWidth() / 2 - 2, frame.getHeight() / 2 + 7 * frame.getHeight() / 18 - 8, 4, 10, 10, 5);
                    g2D.rotate(-Math.toRadians((double)i * 6.0), frame.getWidth() / 2, frame.getHeight() / 2);
                }
                g2D.setColor(Color.WHITE);
                for (i = 1; i < 7; ++i) {
                    g2D.rotate(Math.toRadians(i * 30), frame.getWidth() / 2, frame.getHeight() / 2);
                    g2D.fillRoundRect(frame.getWidth() / 2 - 4, frame.getHeight() / 2 - 7 * frame.getHeight() / 18 - 2, 8, 25, 10, 5);
                    g2D.fillRoundRect(frame.getWidth() / 2 - 4, frame.getHeight() / 2 + 7 * frame.getHeight() / 18 - 23, 8, 25, 10, 5);
                    g2D.rotate(-Math.toRadians(i * 30), frame.getWidth() / 2, frame.getHeight() / 2);
                }
            }

            private void drawDate(Graphics2D g2D) {
                g2D.drawRoundRect(frame.getWidth() / 2 - 15, frame.getHeight() - frame.getHeight() / 3, 30, 30, 15, 10);
                g2D.setFont(new Font("ComicSansMS", 1, 20));
                String date = String.valueOf(LocalDate.now().getDayOfMonth());
                if (date.length() < 2) {
                    date = "0" + date;
                }
                g2D.drawString(date, frame.getWidth() / 2 - date.length() - 10, frame.getHeight() - frame.getHeight() / 3 + 22);
            }

            private void drawSecondNeedle(Graphics2D g2D) {
                g2D.fillOval(frame.getWidth() / 2 - 6, frame.getHeight() / 2 - 6, 12, 12);
                g2D.setColor(Color.RED);
                g2D.drawLine(frame.getWidth() / 2, frame.getHeight() / 2 + 15, frame.getWidth() / 2, frame.getHeight() / 9);
                g2D.fillOval(frame.getWidth() / 2 - 5, frame.getHeight() / 2 - 5, 10, 10);
                g2D.setColor(Color.BLACK);
                g2D.fillOval(frame.getWidth() / 2 - 3, frame.getHeight() / 2 - 3, 6, 6);
                g2D.setColor(Color.WHITE);
            }

            private void drawMinuteNeedle(Graphics2D g2D) {
                g2D.drawLine(frame.getWidth() / 2, frame.getHeight() / 2, frame.getWidth() / 2, frame.getHeight() / 7);
                g2D.drawRoundRect(frame.getWidth() / 2 - 5, frame.getHeight() / 7, 10, frame.getHeight() / 3 - 5, 15, 10);
                g2D.setColor(Color.BLACK);
                g2D.fillRoundRect(frame.getWidth() / 2 - 3, frame.getHeight() / 7, 6, frame.getHeight() / 3 - 5, 15, 10);
                g2D.setColor(Color.WHITE);
            }

            private void drawHourNeedle(Graphics2D g2D) {
                g2D.drawLine(frame.getWidth() / 2, frame.getHeight() / 2, frame.getWidth() / 2, frame.getHeight() / 4);
                g2D.drawRoundRect(frame.getWidth() / 2 - 5, frame.getHeight() / 4 - 15, 10, frame.getHeight() / 4, 15, 10);
                g2D.setColor(Color.BLACK);
                g2D.fillRoundRect(frame.getWidth() / 2 - 3, frame.getHeight() / 4 - 15, 6, frame.getHeight() / 4, 15, 10);
                g2D.setColor(Color.WHITE);
            }
        });
        frame.setVisible(true);
        Timer refrsh = new Timer(10, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.repaint();
            }
        });
        refrsh.start();
    }
}

