/*
 * Decompiled with CFR 0.152.
 */
package calendar;

import calendar.View;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JLabel;

public class DateView
extends View {
    private int maxDays;
    private int firstDay;
    private JLabel[] columns;

    public DateView() {
        this.setLayout(new GridLayout(5, 8));
        this.columns = new JLabel[35];
        this.firstDay = 3;
        this.maxDays = 31;
        int pos = 6;
        for (int i = 0; i < this.columns.length; ++i) {
            this.columns[i] = new JLabel("");
            if (i == pos) {
                this.columns[i].setBorder(BorderFactory.createMatteBorder(1 - pos % 6, 0, 1, 0, Color.lightGray));
                pos += 7;
            } else if (i > 6) {
                this.columns[i].setBorder(BorderFactory.createMatteBorder(0, 0, 1, 1, Color.lightGray));
            } else {
                this.columns[i].setBorder(BorderFactory.createMatteBorder(1, 0, 1, 1, Color.lightGray));
            }
            this.columns[i].setHorizontalAlignment(0);
            this.add(this.columns[i]);
        }
        int i = this.firstDay - 1;
        for (int k = 1; k <= this.maxDays; ++k) {
            if (i >= this.columns.length) {
                i = 0;
            }
            this.columns[i++].setText(Integer.toString(k));
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.setBackground(Color.white);
    }

    public void updateDate(int firstDay, int maxDays, boolean month, int day) {
        this.firstDay = firstDay;
        this.maxDays = maxDays;
        for (int i = 0; i < this.columns.length; ++i) {
            this.columns[i].setText("");
        }
        int i = firstDay - 1;
        for (int k = 1; k <= maxDays; ++k) {
            if (i >= this.columns.length) {
                i = 0;
            }
            if (i == day - 1 && month) {
                this.columns[i++].setText("<html><font color='red'><b>" + Integer.toString(k) + "</b></font></html>");
                continue;
            }
            this.columns[i++].setText(Integer.toString(k));
        }
        this.repaint();
    }
}

