/*
 * Decompiled with CFR 0.152.
 */
package calendar;

import calendar.ButtonPanel;
import calendar.Date;
import calendar.DateView;
import calendar.Days;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.time.DayOfWeek;
import javax.swing.JFrame;

public class DateController {
    private Days days;
    private ButtonPanel buttonPanel;
    private DateView dateView;
    private Date date;
    private JFrame frame;

    public DateController(final Days days, final ButtonPanel buttonPanel, final DateView dateView, final Date date, JFrame frame) {
        this.days = days;
        this.buttonPanel = buttonPanel;
        this.dateView = dateView;
        this.date = date;
        this.frame = frame;
        days.updateMonth(this.returnMonth(date.getMonth()), Integer.toString(date.getYear()));
        buttonPanel.updateMonths(this.returnMonth(date.getPrevMonth()), this.returnMonth(date.getNextMonth()));
        dateView.updateDate(this.returnDay(date.getFirstDay()), date.getMaxDays(), date.isThisMonth(), date.getToday());
        frame.setTitle(this.returnStringDay(date.getDayOfWeek()) + ", " + date.getDay() + " " + this.returnMonth(date.getMonth()) + " " + date.getYear());
        this.buttonPanel.getNextButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                date.gotoNextMonth();
                days.updateMonth(DateController.this.returnMonth(date.getMonth()), Integer.toString(date.getYear()));
                buttonPanel.updateMonths(DateController.this.returnMonth(date.getPrevMonth()), DateController.this.returnMonth(date.getNextMonth()));
                dateView.updateDate(DateController.this.returnDay(date.getFirstDay()), date.getMaxDays(), date.isThisMonth(), date.getToday());
            }
        });
        this.buttonPanel.getPrevButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                date.gotoPrevMonth();
                days.updateMonth(DateController.this.returnMonth(date.getMonth()), Integer.toString(date.getYear()));
                buttonPanel.updateMonths(DateController.this.returnMonth(date.getPrevMonth()), DateController.this.returnMonth(date.getNextMonth()));
                dateView.updateDate(DateController.this.returnDay(date.getFirstDay()), date.getMaxDays(), date.isThisMonth(), date.getToday());
            }
        });
        this.buttonPanel.getThisMonthButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                date.thisMonth();
                days.updateMonth(DateController.this.returnMonth(date.getMonth()), Integer.toString(date.getYear()));
                buttonPanel.updateMonths(DateController.this.returnMonth(date.getPrevMonth()), DateController.this.returnMonth(date.getNextMonth()));
                dateView.updateDate(DateController.this.returnDay(date.getFirstDay()), date.getMaxDays(), date.isThisMonth(), date.getToday());
            }
        });
    }

    private String returnMonth(int month) {
        switch (month) {
            case 1: {
                return "January";
            }
            case 2: {
                return "February";
            }
            case 3: {
                return "March";
            }
            case 4: {
                return "April";
            }
            case 5: {
                return "May";
            }
            case 6: {
                return "June";
            }
            case 7: {
                return "July";
            }
            case 8: {
                return "August";
            }
            case 9: {
                return "September";
            }
            case 10: {
                return "October";
            }
            case 11: {
                return "November";
            }
            case 12: {
                return "December";
            }
        }
        return null;
    }

    private int returnDay(DayOfWeek week) {
        switch (week.getValue()) {
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 5;
            }
            case 5: {
                return 6;
            }
            case 6: {
                return 7;
            }
            case 7: {
                return 1;
            }
        }
        return 0;
    }

    private String returnStringDay(DayOfWeek week) {
        switch (week.getValue()) {
            case 1: {
                return "Monday";
            }
            case 2: {
                return "Tuesday";
            }
            case 3: {
                return "Wednesday";
            }
            case 4: {
                return "Thursday";
            }
            case 5: {
                return "Friday";
            }
            case 6: {
                return "Saturday";
            }
            case 7: {
                return "Sunday";
            }
        }
        return "arrtCalendar";
    }
}

