/*
 * Decompiled with CFR 0.152.
 */
package calendar;

import java.time.DayOfWeek;
import java.time.LocalDate;

public class Date {
    private LocalDate date = LocalDate.now();

    public DayOfWeek getDayOfWeek() {
        return this.date.getDayOfWeek();
    }

    public int getDay() {
        return this.date.getDayOfMonth();
    }

    public void thisMonth() {
        this.date = LocalDate.now();
    }

    public void gotoPrevMonth() {
        this.date = this.date.minusMonths(1L);
    }

    public void gotoNextMonth() {
        this.date = this.date.plusMonths(1L);
    }

    public int getMaxDays() {
        return this.date.lengthOfMonth();
    }

    public DayOfWeek getFirstDay() {
        return this.date.withDayOfMonth(1).getDayOfWeek();
    }

    public int getMonth() {
        return this.date.getMonthValue();
    }

    public int getNextMonth() {
        LocalDate kk = this.date.withDayOfMonth(1);
        return kk.plusMonths(1L).getMonthValue();
    }

    public int getPrevMonth() {
        LocalDate kk = this.date.withDayOfMonth(1);
        return kk.minusMonths(1L).getMonthValue();
    }

    public int getYear() {
        return this.date.getYear();
    }

    public int getDayOfMonth() {
        return this.date.getDayOfMonth();
    }

    public int getToday() {
        return LocalDate.now().getDayOfMonth();
    }

    public boolean isThisMonth() {
        return LocalDate.now().getYear() == this.date.getYear() && LocalDate.now().getMonth() == this.date.getMonth();
    }
}

